<?php 
	class Users {
		private $id;
		private $mobile_number;
		private $weapon_code;
		private $points;
		private $user_id ;
		private $old_points;

		private $tableName = 'users';
		private $tableNameTwo = 'users_weapon';
		private $dbConn;

		function setUserId($user_id) { $this->user_id = $user_id; }
		function getUserId() { return $this->user_id; }
		function setMobileNumber($mobile_number) { $this->mobile_number = $mobile_number; }
		function getMobileNumber() { return $this->mobile_number; }
		function setWeaponCode($weapon_code) { $this->weapon_code = $weapon_code; }
		function getWeaponCode() { return $this->weapon_code; }
		function setPoints($points) { $this->points = $points; }
		function getPoints() { return $this->points; }
		function setOldPoints($old_points) { $this->old_points = $old_points; }
		function getOldPoints() { return $this->old_points; }

		public function __construct() {
			$db = new DbConnect();
			$this->dbConn = $db->connect();
			header("content-type: application/json");
		}
		

		public function insert() {
			
			$sql = 'INSERT INTO ' . $this->tableName . '(id, mobile_number, points) 
			VALUES(null, :mobile_number, :points)';

			$stmt = $this->dbConn->prepare($sql);

			$stmt->bindParam(':mobile_number', $this->mobile_number);
			$stmt->bindParam(':points', $this->points);
			
			if($stmt->execute()) {
				$user_data = $this->getUserByMobileNumber();
				$user_id = $user_data[0]['id'];
				$this->setUserId($user_id);
				$this->userWeaponInsert();
				return true;
			} else {
				return false;
			}
		}
		function userWeaponInsert() {
			$sql_two = 'INSERT INTO ' . $this->tableNameTwo . '(id, user_id, weapon_code) 
			VALUES(null, :user_id, :weapon_code)';

			$stmt = $this->dbConn->prepare($sql_two);
			$stmt->bindParam(':user_id', $this->user_id);
			$stmt->bindParam(':weapon_code', $this->weapon_code);
			
			if($stmt->execute()) {
				return true;
			} else {
				return false;
			}			
		}
		public function getUserByMobileNumber() {
			//echo "SELECT * FROM " . $this->tableName. " WHERE mobile_number = ".$this->mobile_number;die();
			$stmt = $this->dbConn->prepare("SELECT * FROM " . $this->tableName. " WHERE mobile_number = ".$this->mobile_number);
			$stmt->execute();
			$user = $stmt->fetchAll(PDO::FETCH_ASSOC);
			return $user;
		}
		public function getAllUsers() {
			$stmt = $this->dbConn->prepare("SELECT * FROM " . $this->tableName);
			$stmt->execute();
			$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
			return $customers;
		}
		public function update() {
			$update_points = $this->getPoints() + $this->getOldPoints();
			$sql = "UPDATE " .$this->tableName." SET";
			if( null != $this->getPoints()) {
				$sql .=	" points = '" . $update_points . "'";
			}

			$sql .=	" 
					WHERE 
						mobile_number = :mobile_number";

			$stmt = $this->dbConn->prepare($sql);
			$stmt->bindParam(':mobile_number', $this->mobile_number);

			if($stmt->execute()) {
				$this->userWeaponInsert();
				return true;
			} else {
				return false;
			}
		}

		public function delete() {
			$stmt = $this->dbConn->prepare('DELETE FROM ' . $this->tableName . ' WHERE id = :userId');
			$stmt->bindParam(':userId', $this->id);
			
			if($stmt->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>